package java.game.cars;

import java.util.*;
import java.util.resource.*;
import java.game.parts.bodypart.*;


public class Stallion_FL_door extends FrontDoor
{
	public Stallion_FL_door( int id )
	{
		super( id );
		carCategory = PACKAGE;
		name = "Stallion front left door";

		value = 566;
	}
	
	public void addStockParts( int actcolor, float optical, float power )
	{
		super.addStockParts( actcolor, optical, power );

		float part_random;

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_03.stallion:0x000000E4r, "FL window", actcolor, optical, power );
			addPart( cars.cat_03.stallion:0x000000EAr, "L mirror", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) 
			{
				addPart( cars.cat_03.stallion:0x000000E4r, "FL window", actcolor, optical, power );
				if ( optical >= random() ) addPart( cars.cat_03.stallion:0x000000EAr, "L mirror", actcolor, optical, power );
			}
		}
	}
}
